	% EXample 14.28
	
	clear all, close all, clc
	N = 9;									% Filter order	
	Nd = 11;								% Incremental delay cases
	d = 0.1*(0:Nd-1)-0.5; 				% Fractional delay increments
	wT = linspace(0,pi,1000);	wT(1) = 1;	% Avoid divide by zero
	Denom = zeros(Nd, N+1);  				% Allpass denominators
	phasedelay = zeros(Nd,1000);		
	for m = 1:Nd							% Design the Thiran allpass filters
		ap(1) = 1;
		for k = 1:N
			cd = (-1)^k* nchoosek(N,k);		% binomial coefficient, n!/((nk)! k!)
			prod = 1;
			for n = 0:N
				prod = prod*(d(m)+n)/(d(m)+k+n);
			end 
			ap(k+1) = cd*prod;
		end
		Denom(m,:) = ap;
		H = freqz(fliplr(Denom(m,:)),Denom(m,:),wT);	% Allpass filter	
		phasedelay(m,:) = -unwrap(angle(H))./wT;
		phasedelay(m,1) = phasedelay(m,2); 	% Correct the first value
	end
	wT(1) = 0; 
	
	PLOT_FD_PHASE_DELAY(wT, phasedelay, Nd, d, N)
	axis([0 pi (N-0.6) (N+0.6)])
	
	
